function [E3,L3]=IntegralesProblema3Cp(r3,v3,N1)
% -------------------------------------------------------
% function INTEGRALESPROBLEMA2C. Integrales de movimiento
% del problema de dos cuerpos.
%
% PARMETROS DE ENTRADA
% r: matriz con el vector de posicin del cuerpo en rbita (en U.A.)
% en funcin del tiempo
% v: matriz con vector velocidad del cuerpo en rbita (en km/s) en funcin
% del tiempo.
% N: masa de la estrella central (en masas solares)
% Suponemos que en las matrices los vectores para un instante dado aparecen
% en una columna (es decir, el tiempo aumenta a lo largo de una fila)
%
% PARMETROS DE SALIDA
% E: energa por unidad de masa del planeta (en km^2/s^2)
% L: momento angular por unidad de masa del planeta (en U.A. km /s)
%
E3 = 0.5*(v3(1,:).^2+v3(2,:).^2)-887.2*N1*(r3(1,:).^2+r3(2,:).^2).^(-1/2);
L3 = r3(1,:).*v3(2,:) - r3(2,:).*v3(1,:);
end
